document.addEventListener("DOMContentLoaded", function () {
  function detectIPAddresses() {
    let ipv4 = null;
    let ipv6 = null;

    fetch("https://api.ipify.org?format=json")
      .then((response) => response.json())
      .then((data) => {
        ipv4 = data.ip; // Store IPv4 address
        checkResult();
      })
      .catch((error) => {
        console.log("Error fetching IPv4 address", error);
        ipv4 = "Not available";
        checkResult();
      });

    fetch("https://api6.ipify.org?format=json")
      .then((response) => response.json())
      .then((data) => {
        ipv6 = data.ip; // Store IPv6 address
        checkResult();
      })
      .catch((error) => {
        console.log("Error fetching IPv6 address", error);
        ipv6 = "Not available";
        checkResult();
      });

    function checkResult() {
      const ipField = document.getElementById("pt_user_ip");

      if (ipv6 && ipv6 !== "Not available") {
        ipField.value = ipv6;
      } else if (ipv4 && ipv4 !== "Not available") {
        ipField.value = ipv4;
      }
    }
  }

  detectIPAddresses();
});
