<?php
if (!defined("ABSPATH")) {
    exit();
}

return [
    // === Section 1: General ===
    "section_1_title" => [
        "type" => "title",
        "title" => "General",
        "description" => "Configure generic settings for Paytree below.",
    ],
    "enabled" => [
        "title" => "Enable/Disable",
        "label" => "Enable Paytree",
        "type" => "checkbox",
        "default" => "no",
        "description" => "Enable Paytree for processing payments.",
    ],
    "title" => [
        "title" => "Title",
        "type" => "text",
        "default" => "Online Payments",
        "description" => "Heading shoppers will see on checkout page.",
    ],
    "description" => [
        "title" => "Description",
        "type" => "textarea",
        "default" => "Pay securely using card, crypto, or wire transfer.",
        "description" =>
            "Description shoppers will see on checkout page (Under heading).",
    ],
    "enable_ip_detection" => [
        "title" => "Enable JS IP Detection",
        "type" => "checkbox",
        "default" => "yes",
        "description" =>
            'Enable this option if your host doesn\'t support IPv6/AAAA',
    ],

    // === Section 2: API ===
    "section_2_title" => [
        "type" => "title",
        "title" => "API Settings",
        "description" => "Configure connectivity settings below.",
    ],
    "api_endpoint" => [
        "title" => "API Endpoint",
        "type" => "text",
        "default" => "https://api.domain.com/v1/transaction/payment_intent/",
        "description" => "The API endpoint.",
    ],
    "api_token" => [
        "title" => "API Token",
        "type" => "text",
        "default" => "",
        "description" => "API token (Available in back office)",
    ],

    // === Section 3: Payment Methods ===
    "section_3_title" => [
        "type" => "title",
        "title" => "Payment Methods",
        "description" =>
            "Configure and toggle between different payment methods.",
    ],
    "enable_card_method" => [
        "title" => "Card Payments",
        "type" => "checkbox",
        "label" => "Enable Card Payments",
        "default" => "yes",
    ],
    "enable_crypto_method" => [
        "title" => "Crypto Payments",
        "type" => "checkbox",
        "label" => "Enable Crypto Payments",
        "default" => "no",
    ],
    "enable_wire_method" => [
        "title" => "Wire Payments",
        "type" => "checkbox",
        "label" => "Enable Wire Payments",
        "default" => "no",
    ],
    "enable_paypal_method" => [
        "title" => "Paypal Payments",
        "type" => "checkbox",
        "label" => "Enable Paypal Payments",
        "default" => "no",
    ],
    "enable_klarna_method" => [
        "title" => "Klarna Payments",
        "type" => "checkbox",
        "label" => "Enable Klarna Payments",
        "default" => "no",
    ],
    "enable_ideal_method" => [
        "title" => "iDEAL Payments",
        "type" => "checkbox",
        "label" => "Enable iDEAL Payments",
        "default" => "no",
    ],
    "enable_bancontact_method" => [
        "title" => "Bancontact Payments",
        "type" => "checkbox",
        "label" => "Enable Bancontact Payments",
        "default" => "no",
    ],

    // Default method selection
    "default_method" => [
        "title" => "Default Payment Method",
        "type" => "select",
        "description" => "Which method should be pre-selected at checkout.",
        "default" => "card",
        "options" => [
            "card" => "Card",
            "crypto" => "Crypto",
            "wire" => "Wire",
            "paypal" => "PayPal",
            "klarna" => "Klarna",
            "ideal" => "iDEAL",
            "bancontact" => "Bancontact",
        ],
    ],

    // === Rename Methods Section ===
    "rename_title" => [
        "type" => "title",
        "title" => "Rename Methods",
        "description" => "Override display names for each method below.",
    ],
    "rename_card" => [
        "title" => "Card Label",
        "type" => "text",
        "default" => "",
        "description" => "Leave blank to use default name 'Card'",
    ],
    "rename_crypto" => [
        "title" => "Crypto Label",
        "type" => "text",
        "default" => "",
        "description" => "Leave blank to use default name 'Crypto'",
    ],
    "rename_wire" => [
        "title" => "Wire Label",
        "type" => "text",
        "default" => "",
        "description" => "Leave blank to use default name 'Wire'",
    ],
    "rename_paypal" => [
        "title" => "PayPal Label",
        "type" => "text",
        "default" => "",
        "description" => "Leave blank to use default name 'PayPal'",
    ],
    "rename_klarna" => [
        "title" => "Klarna Label",
        "type" => "text",
        "default" => "",
        "description" => "Leave blank to use default name 'Klarna'",
    ],
    "rename_ideal" => [
        "title" => "iDEAL Label",
        "type" => "text",
        "default" => "",
        "description" => "Leave blank to use default name 'iDEAL'",
    ],
    "rename_bancontact" => [
        "title" => "Bancontact Label",
        "type" => "text",
        "default" => "",
        "description" => "Leave blank to use default name 'Bancontact'",
    ],

    // === Section 4: Force Routes ===

    "section_4_title" => [
        "type" => "title",
        "title" => "Force Routes",
        "description" => "Force flow/methods to use a specific route.",
    ],
    "force_route_card" => [
        "title" => "Force Route for Cards",
        "type" => "text",
        "default" => "",
        "description" => "Leave blank to use default settings / orchestration",
    ],
    "force_route_crypto" => [
        "title" => "Force Route for Crypto",
        "type" => "text",
        "default" => "",
        "description" => "Leave blank to use default settings / orchestration",
    ],
    "force_route_wire" => [
        "title" => "Force Route for Wire",
        "type" => "text",
        "default" => "",
        "description" => "Leave blank to use default settings / orchestration",
    ],
    "force_route_paypal" => [
        "title" => "Force Route for PayPal",
        "type" => "text",
        "default" => "",
        "description" => "Leave blank to use default settings / orchestration",
    ],
    "force_route_klarna" => [
        "title" => "Force Route for Klarna",
        "type" => "text",
        "default" => "",
        "description" => "Leave blank to use default settings / orchestration",
    ],
    "force_route_ideal" => [
        "title" => "Force Route for iDEAL",
        "type" => "text",
        "default" => "",
        "description" => "Leave blank to use default settings / orchestration",
    ],
    "force_route_bancontact" => [
        "title" => "Force Route for Bancontact",
        "type" => "text",
        "default" => "",
        "description" => "Leave blank to use default settings / orchestration",
    ],

    // === Section 5: Developer Tools ===
    "section_5_title" => [
        "type" => "title",
        "title" => "Developers",
        "description" => "Advanced for configuration and debugging.",
    ],
    "log_request_body" => [
        "title" => "Log API payload",
        "label" => "Enable",
        "type" => "checkbox",
        "default" => "no",
        "description" => "Log all API requests payload/body",
    ],
    "log_request_resp" => [
        "title" => "Log API response",
        "label" => "Enable",
        "type" => "checkbox",
        "default" => "no",
        "description" => "Log all API responses",
    ],
];
